<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cif="cif" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
<xsl:param select="cif:xslShowHelp" name="xslShowHelp"/>
<xsl:param select="cif:xslRootDirectory" name="xslRootDirectory"/>
  <!-- Least Squares Report -->
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
    <html>
      <head>
        <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
        <!-- Title displayed in browser Title Bar -->
        <title lang="en">Výpis délek a směru</title>
      </head>
      <body>
        <xsl:choose>
          <xsl:when test="$xslShowHelp = 'true'">
            <xsl:call-template name="StyleSheetHelp"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="InRoads">
              <xsl:for-each select="GeometryProject">
                <center>
                  <!-- Report Title -->
                  <h2 lang="en">Výpis délek a směru</h2>
                  <p lang="en">
                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                  </p>
                </center>
                <p lang="en" style="text-align:center;font-size:80%">
                  <strong>Aktivní geografický systém:&#xa0;</strong>
                  &#xa0; <xsl:value-of select="//@coordinateSystemName"/>
                  &#xa0; <xsl:value-of select="//@coordinateSystemDescription"/>
                  <xsl:if test="//@linearUnits = 'I'">, Stopa</xsl:if>
                  <xsl:if test="//@linearUnits = 'F'">, Survey stopa</xsl:if>
                  <xsl:if test="//@linearUnits = 'M'">, Metr</xsl:if>
                </p>
                <hr/>
                <center>
                  <h4>Měřené prvky</h4>
                </center>
                <xsl:if test="InverseLine">
                  <hr size="1px"/>
                  <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                    <tbody>
                      <tr>
                        <th align="left" nowrap="nowrap">LINIE&#xa0;</th>
                      </tr>
                    </tbody>
                  </table>
                  <table class="margin" cellpadding="1" cellspacing="1" width="80%">
                    <colgroup span="8">
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                    </colgroup>
                    <thead style="display:table-header-group">
                      <tr>
                      </tr>
                      <tr>
                        <th class="underline" lang="en" align="left">Směr</th>
                        <th class="underline" lang="en" align="left">Vzdálenost</th>
                        <th class="underline" lang="en" align="right">Y</th>
                        <th class="underline" lang="en" align="right">X</th>
                        <th class="underline" lang="en" align="right">Z</th>
                        <th class="underline" lang="en" align="right">Název bodu</th>
                      </tr>
                    </thead>
                    <tbody>
                      <xsl:for-each select="InverseLine">
                        <tr>
                          <td align="left">
                            <xsl:value-of select="cif:directionFormat(number(@direction))"/>
                          </td>
                          <td align="left">
                            <xsl:value-of select="cif:distanceFormat(number(@distance))"/>
                          </td>
                          <xsl:for-each select="Start">
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="@pointName"/>
                            </td>
                          </xsl:for-each>
                        </tr>
                        <tr>
                          <xsl:for-each select="End">
                            <td align="left">
                            </td>
                            <td align="left">
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="@pointName"/>
                            </td>                            
                          </xsl:for-each>
                        </tr>

                        <xsl:if test="//@SDIS">
                          <tr>
                            <th align="left" nowrap="nowrap">SDIS = &#xa0;</th>
                            <td align="left" nowrap="nowrap">
                              <xsl:value-of select="cif:distanceFormat(number(@SDIS))"/>
                            </td>
                            <!-- <td align="right" colspan="1" lang="en"></td>-->
                          </tr>
                          <tr>
                            <th align="left" nowrap="nowrap">DeltaZ = &#xa0;</th>
                            <td align="left" nowrap="nowrap">
                              <xsl:value-of select="cif:distanceFormat(number(@DeltaZ))"/>
                            </td>
                            <!-- <td align="right" colspan="1" lang="en"></td>-->
                          </tr>                          
                        </xsl:if>

                      </xsl:for-each>
                    </tbody>
                  </table>
                </xsl:if>
                <xsl:for-each select="AccumulatedDistance">
                  <table class="margin" cellpadding="1" cellspacing="1" width="20%">
                    <tbody>
                      <tr>
                        <th align="left" nowrap="nowrap">Celková délka = &#xa0;</th>
                        <td align="left" nowrap="nowrap">
                          <xsl:value-of select="cif:distanceFormat(number(@accumulatedDistance))"/>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                </xsl:for-each>
                <hr size="1px"/>
                <xsl:for-each select="InverseByElement">


                  <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                    <tbody>
                      <tr>
                        <th align="left" nowrap="nowrap"> </th>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">MĚŘENÝ PRVEK&#xa0;</th>
                      </tr>
                    </tbody>
                  </table>

                        <xsl:for-each select="SubElement">
                          <hr size="1px"/>
                          <xsl:if test=".//@type = 'Line'">
                            <!--<hr size="1px"/>-->
                            <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                              <tbody>
                                <tr>
                                  <th align="left" nowrap="nowrap">PŘÍMÁ&#xa0;</th>
                                </tr>
                              </tbody>
                            </table>
                            <table class="margin" cellpadding="1" cellspacing="1" width="80%">
                              <colgroup span="8">
                                <col width="5%"/>
                                <col width="5%"/>
                                <col width="5%"/>
                                <col width="5%"/>
                                <col width="5%"/>
                              </colgroup>
                              <thead style="display:table-header-group">
                                <tr>
                                </tr>
                                <tr>
                                  <th class="underline" lang="en" align="left">Směr</th>
                                  <th class="underline" lang="en" align="left">Vzdálenost</th>
                                  <th class="underline" lang="en" align="right">Y</th>
                                  <th class="underline" lang="en" align="right">X</th>
                                  <th class="underline" lang="en" align="right">Z</th>
                                </tr>
                              </thead>
                              <tbody>
                                <tr>
                                  <td align="left">
                                    <xsl:value-of select="cif:directionFormat(number(@direction))"/>
                                  </td>
                                  <td align="left">
                                    <xsl:value-of select="cif:distanceFormat(number(@distance))"/>
                                  </td>
                                  <xsl:for-each select="Start">
                                    <td align="right">
                                      <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                                    </td>
                                    <td align="right">
                                      <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                                    </td>
                                    <td align="right">
                                      <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                                    </td>
                                  </xsl:for-each>
                                </tr>
                                <tr>
                                  <xsl:for-each select="End">
                                    <td align="left">
                                    </td>
                                    <td align="left">
                                    </td>
                                    <td align="right">
                                      <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                                    </td>
                                    <td align="right">
                                      <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                                    </td>
                                    <td align="right">
                                      <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                                    </td>
                                  </xsl:for-each>
                                </tr>
                                <xsl:if test="//@SDIS">
                                  <tr>
                                    <th align="left" nowrap="nowrap">SDIS = &#xa0;</th>
                                    <td align="left" nowrap="nowrap">
                                      <xsl:value-of select="cif:distanceFormat(number(@SDIS))"/>
                                    </td>
                                    <!-- <td align="right" colspan="1" lang="en"></td>-->
                                  </tr>
                                  <tr>
                                    <th align="left" nowrap="nowrap">DeltaZ = &#xa0;</th>
                                    <td align="left" nowrap="nowrap">
                                      <xsl:value-of select="cif:distanceFormat(number(@DeltaZ))"/>
                                    </td>
                                    <!-- <td align="right" colspan="1" lang="en"></td>-->
                                  </tr>
                                </xsl:if>

                              </tbody>
                            </table>
                          </xsl:if>

                          <xsl:if test=".//@type = 'Arc'">
                            <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                              <tbody>
                                <tr>
                                  <th align="left" nowrap="nowrap"> </th>
                                </tr>
                                <tr>
                                  <th align="left" nowrap="nowrap">OBLOUK&#xa0;</th>
                                </tr>
                              </tbody>
                            </table>
                            <table class="margin" cellpadding="1" cellspacing="1" width="80%">
                              <colgroup span="8">
                                <col width="5%"/>
                                <col width="5%"/>
                                <col width="5%"/>
                                <col width="5%"/>
                              </colgroup>
                              <thead style="display:table-header-group">
                                <tr>
                                </tr>
                                <tr>
                                  <th class="underline" lang="en" align="left"></th>
                                  <th class="underline" lang="en" align="right">Y</th>
                                  <th class="underline" lang="en" align="right">X</th>
                                  <th class="underline" lang="en" align="right">Z</th>
                                </tr>
                              </thead>
                              <tbody>
                                <tr>
                                  <tr>
                                    <xsl:for-each select="Start">
                                      <td align="right">
                                        PC ()
                                      </td>
                                      <td align="right">
                                        <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                                      </td>
                                      <td align="right">
                                        <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                                      </td>
                                      <td align="right">
                                        <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                                      </td>
                                    </xsl:for-each>
                                  </tr>
                                  <tr>
                                    <xsl:for-each select="PI">
                                      <td align="right">
                                        V ()
                                      </td>
                                      <td align="right">
                                        <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                                      </td>
                                      <td align="right">
                                        <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                                      </td>
                                      <td align="right">
                                        <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                                      </td>
                                    </xsl:for-each>
                                  </tr>
                                  <tr>
                                    <xsl:for-each select="Center">
                                      <td align="right">
                                        CC ()
                                      </td>
                                      <td align="right">
                                        <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                                      </td>
                                      <td align="right">
                                        <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                                      </td>
                                      <td align="right">
                                        <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                                      </td>
                                    </xsl:for-each>
                                  </tr>
                                  <tr>
                                    <xsl:for-each select="End">
                                      <td align="right">
                                        PT ()
                                      </td>
                                      <td align="right">
                                        <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                                      </td>
                                      <td align="right">
                                        <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                                      </td>
                                      <td align="right">
                                        <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                                      </td>
                                    </xsl:for-each>
                                  </tr>
                                  <tr>
                                    <td align="right">
                                      Poloměr:
                                    </td>
                                    <td align="right">
                                      <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td align="right">
                                      Delta:
                                    </td>
                                    <td align="right">
                                      <xsl:value-of select="cif:angularFormat(number(@delta))"/>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td align="right">
                                      Stupeň křivosti:
                                    </td>
                                    <td align="right">
                                      <xsl:value-of select="cif:angularFormat(number(@degreeOfCurve))"/>
                                    </td>
                                  </tr>

                                  <tr>
                                    <td align="right" lang="en">Délka:</td>
                                    <td align="right">
                                      <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td align="right" lang="en">Tečna:</td>
                                    <td align="right">
                                      <xsl:value-of select="cif:distanceFormat(number(@tangentLength))"/>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td align="right" lang="en">Tětiva:</td>
                                    <td align="right">
                                      <xsl:value-of select="cif:distanceFormat(number(@chord))"/>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td align="right" lang="en">Střední pořadnice:</td>
                                    <td align="right">
                                      <xsl:value-of select="cif:distanceFormat(number(@middleOrdinate))"/>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td align="right" lang="en">zo:</td>
                                    <td align="right">
                                      <xsl:value-of select="cif:distanceFormat(number(@externalDistance))"/>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td align="right" lang="en">Počáteční směr tečny:</td>
                                    <td align="right">
                                      <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionStart))"/>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td align="right" lang="en">Počáteční radiální směr:</td>
                                    <td align="right">
                                      <xsl:value-of select="cif:directionFormat(number(@radialDirectionStart))"/>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td align="right" lang="en">Směr tětivy:</td>
                                    <td align="right">
                                      <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td align="right" lang="en">Koncový radiální směr:</td>
                                    <td align="right">
                                      <xsl:value-of select="cif:directionFormat(number(@radialDirectionEnd))"/>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td align="right" lang="en">Koncový tečný směr:</td>
                                    <td align="right">
                                      <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionEnd))"/>
                                    </td>
                                  </tr>
                                </tr>
                                <tr/>
                              </tbody>
                            </table>
                          </xsl:if>
                        </xsl:for-each>
                </xsl:for-each>                
                <xsl:for-each select="InverseArc">
                  <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                    <tbody>
                      <tr>
                        <th align="left" nowrap="nowrap"> </th>                        
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">OBLOUK&#xa0;</th>
                      </tr>
                    </tbody>
                  </table>
                  <table class="margin" cellpadding="1" cellspacing="1" width="80%">
                    <colgroup span="8">
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                    </colgroup>
                    <thead style="display:table-header-group">
                      <tr>
                      </tr>
                      <tr>
                        <th class="underline" lang="en" align="left"></th>
                        <th class="underline" lang="en" align="right">Y</th>
                        <th class="underline" lang="en" align="right">X</th>
                        <th class="underline" lang="en" align="right">Z</th>
                        <th class="underline" lang="en" align="right">Název bodu</th>
                      </tr>
                    </thead>
                    <tbody>
                        <tr>
                          <tr>
                            <xsl:for-each select="Start">
                              <td align="right">
                                PC ()
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="@pointName"/>
                              </td>
                            </xsl:for-each>
                          </tr>
                          <tr>
                          <xsl:for-each select="PI">
                            <td align="right">
                              V ()
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="@pointName"/>
                            </td>
                          </xsl:for-each>
                          </tr>
                          <tr>
                            <xsl:for-each select="Center">
                              <td align="right">
                                CC ()
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="@pointName"/>
                              </td>
                            </xsl:for-each>
                          </tr>
                          <tr>
                          <xsl:for-each select="End">
                            <td align="right">
                              PT ()
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="@pointName"/>
                            </td>
                          </xsl:for-each>
                          </tr>
                          <tr>
                            <td align="right">
                              Poloměr:
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right">
                              Delta:
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@delta))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right">
                              Stupeň křivosti:
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:angularFormat(number(@degreeOfCurve))"/>
                            </td>
                          </tr>

                          <tr>
                            <td align="right" lang="en">Délka:</td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" lang="en">Tečna:</td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@tangentLength))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" lang="en">Tětiva:</td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@chord))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" lang="en">Střední pořadnice:</td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@middleOrdinate))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" lang="en">zo:</td>
                            <td align="right">
                              <xsl:value-of select="cif:distanceFormat(number(@externalDistance))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" lang="en">Počáteční směr tečny:</td>
                            <td align="right">
                              <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionStart))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" lang="en">Počáteční radiální směr:</td>
                            <td align="right">
                              <xsl:value-of select="cif:directionFormat(number(@radialDirectionStart))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" lang="en">Směr tečny:</td>
                            <td align="right">
                              <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" lang="en">Koncový radiální směr:</td>
                            <td align="right">
                              <xsl:value-of select="cif:directionFormat(number(@radialDirectionEnd))"/>
                            </td>
                          </tr>
                          <tr>
                            <td align="right" lang="en">Koncový směr tečny:</td>
                            <td align="right">
                              <xsl:value-of select="cif:directionFormat(number(@tangentialDirectionEnd))"/>
                            </td>
                          </tr>
                        </tr>
                      <tr/>
                    </tbody>
                  </table>
              </xsl:for-each>
                <xsl:for-each select="InverseRadial">
                  <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                    <tbody>
                      <tr>
                        <th align="left" nowrap="nowrap"> </th>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">RADIÁLNĚ&#xa0;</th>
                      </tr>
                    </tbody>
                  </table>
                  <table class="margin" cellpadding="1" cellspacing="1" width="80%">
                    <colgroup span="8">
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                    </colgroup>
                    <thead style="display:table-header-group">
                      <tr>
                      </tr>
                      <tr>
                        <th class="underline" lang="en" align="left"></th>
                        <th class="underline" lang="en" align="right">Směr</th>
                        <th class="underline" lang="en" align="right">Vzdálenost</th>
                        <th class="underline" lang="en" align="right">Y</th>
                        <th class="underline" lang="en" align="right">X</th>
                        <th class="underline" lang="en" align="right">Z</th>
                        <th class="underline" lang="en" align="right">Název bodu</th>
                      </tr>
                    </thead>
                    <tbody>
                      <tr>
                        <tr>
                          <xsl:for-each select="Backsight">
                            <td align="right">
                              Bod zpět
                            </td>
                            <td align="right" colspan="2" lang="en"></td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="@pointName"/>
                            </td>
                          </xsl:for-each>
                        </tr>
                        <tr>
                          <xsl:for-each select="Occupied">
                            <td align="right">
                              Obsazený bod
                            </td>
                            <td align="right" colspan="2" lang="en"></td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="@pointName"/>
                            </td>
                          </xsl:for-each>
                        </tr>
                        <tr>
                          <xsl:for-each select="RadialPoint">
                            <td align="right">
                              Radiálné bod
                            </td>
                            <td align="right" colspan="2" lang="en"></td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                            </td>
                            <td align="right">
                              <xsl:value-of select="@pointName"/>
                            </td>
                            <tr>
                              <td align="right" colspan="1" lang="en"></td>
                              <td align="right">
                                <xsl:value-of select="cif:directionFormat(number(@direction))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:distanceFormat(number(@distance))"/>
                              </td>
                            </tr>
                            <tr>
                              <td align="right" colspan="1" lang="en"></td>
                              <td align="right">
                                <xsl:value-of select="cif:angularFormat(number(@deflectionAngle))"/>
                              </td>
                              <td align="right">
                                Úhel odchylky
                              </td>
                            </tr>
                            <tr>
                              <td align="right" colspan="1" lang="en"></td>
                              <td align="right">
                                <xsl:value-of select="cif:angularFormat(number(@angleLeft))"/>
                              </td>
                              <td align="right">
                                Úhel vlevo
                              </td>
                            </tr>
                            <tr>
                              <td align="right" colspan="1" lang="en"></td>
                              <td align="right">
                                <xsl:value-of select="cif:angularFormat(number(@angleRight))"/>
                              </td>
                              <td align="right">
                                Úhel vpravo
                              </td>
                            </tr>
                            <xsl:if test="//@SDIS">
                              <tr>
                                <td align="right" colspan="1" lang="en"></td>
                                <td align="right">
                                  <xsl:value-of select="cif:distanceFormat(number(@SDIS))"/>
                                </td>
                                <td align="right">
                                  SDIS
                                </td>
                              </tr>
                              <tr>
                                <td align="right" colspan="1" lang="en"></td>
                                <td align="right">
                                  <xsl:value-of select="cif:distanceFormat(number(@DeltaZ))"/>
                                </td>
                                <td align="right">
                                  DeltaZ
                                </td>
                              </tr>
                            </xsl:if>
                          </xsl:for-each>
                        </tr>
                      </tr>
                      <tr/>
                    </tbody>
                  </table>
                </xsl:for-each>
                <xsl:for-each select="InversePerpendicular">
                  <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                    <tbody>
                      <tr>
                        <th align="left" nowrap="nowrap"> </th>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">KOLMO&#xa0;</th>
                      </tr>
                    </tbody>
                  </table>
                  <table class="margin" cellpadding="1" cellspacing="1" width="80%">
                    <colgroup span="8">
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                      <col width="5%"/>
                    </colgroup>
                    <thead style="display:table-header-group">
                      <tr>
                      </tr>
                      <tr>
                        <th class="underline" lang="en" align="left"></th>
                        <th class="underline" lang="en" align="right">Směr</th>
                        <th class="underline" lang="en" align="right">Vzdálenost</th>
                        <th class="underline" lang="en" align="right">Y</th>
                        <th class="underline" lang="en" align="right">X</th>
                        <th class="underline" lang="en" align="right">Z</th>
                        <th class="underline" lang="en" align="right">Název bodu</th>
                      </tr>
                    </thead>
                    <tbody>
                      <xsl:if test="//@perpendicularType = 'ByPoints'">
                        <tr>
                          <th align="left" nowrap="nowrap">Kolmo mezi body&#xa0;</th>
                        </tr>

                        <tr>
                        <xsl:for-each select="baseLine">
                          <tr>
                            <xsl:for-each select="Start">
                              <td align="right">
                                Počáteční bod
                              </td>
                              <td align="right" colspan="2" lang="en"></td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="@pointName"/>
                              </td>

                            </xsl:for-each>
                          </tr>
                          <tr>
                            <xsl:for-each select="End">
                              <td align="right">
                                Bod zpět
                              </td>
                              <td align="right" colspan="2" lang="en"></td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="@pointName"/>
                              </td>
                            </xsl:for-each>
                          </tr>
                        </xsl:for-each>
                        <tr>
                          <xsl:for-each select="InversePerpendicularLine">
                            <td align="right">
                              Bod s odstupem
                            </td>
                            <xsl:for-each select="Start">
                              <td align="right" colspan="2" lang="en"></td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="@pointName"/>
                              </td>
                            </xsl:for-each>
                            <tr>
                              <td align="right" colspan="1" lang="en"></td>
                              <td align="right">
                                <xsl:value-of select="cif:directionFormat(number(@directionBaseElement))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:distanceFormat(number(@distanceAlong))"/>
                              </td>
                            </tr>
                            <tr>
                              <td align="right" colspan="1" lang="en"></td>
                              <td align="right">
                                <xsl:value-of select="cif:directionFormat(number(@directionOffset))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:distanceFormat(number(@distanceOffset))"/>
                              </td>
                            </tr>
                            <xsl:if test="//@SDIS">
                              <tr>
                                <th align="left" nowrap="nowrap">SDIS = &#xa0;</th>
                                <td align="left" nowrap="nowrap">
                                  <xsl:value-of select="cif:distanceFormat(number(@SDIS))"/>
                                </td>
                                <!-- <td align="right" colspan="1" lang="en"></td>-->
                              </tr>
                              <tr>
                                <th align="left" nowrap="nowrap">DeltaZ = &#xa0;</th>
                                <td align="left" nowrap="nowrap">
                                  <xsl:value-of select="cif:distanceFormat(number(@DeltaZ))"/>
                                </td>
                                <!-- <td align="right" colspan="1" lang="en"></td>-->
                              </tr>
                            </xsl:if>                            
                          </xsl:for-each>
                        </tr>
                      </tr>
                      <tr/>
                      </xsl:if>
                      <xsl:if test="//@perpendicularType = 'ByElement'">
                        <tr>
                          <th align="left" nowrap="nowrap">Kolmo podél prvku&#xa0;</th>
                        </tr>

                        <tr>
                          <td align="right">
                            Délka prvku
                          </td>
                          <td align="right" colspan="1" lang="en"></td>
                          <td align="right">
                            <xsl:value-of select="cif:distanceFormat(number(@elementLength))"/>
                          </td>                          
                          <tr>
                            <xsl:for-each select="InversePerpendicularLine">
                              <td align="right">
                                Bod s odstupem
                              </td>
                              <xsl:for-each select="Start">
                                <td align="right" colspan="2" lang="en"></td>
                                <td align="right">
                                  <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="@pointName"/>
                                </td>
                              </xsl:for-each>
                              <tr>
                                <td align="right" colspan="1" lang="en"></td>
                                <td align="right">
                                  Podél prvku
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:distanceFormat(number(@distanceAlong))"/>
                                </td>
                              </tr>
                              <tr>
                                <td align="right" colspan="1" lang="en"></td>
                                <td align="right">
                                  <xsl:value-of select="cif:directionFormat(number(@directionOffset))"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:distanceFormat(number(@distanceOffset))"/>
                                </td>
                              </tr>
                              <xsl:if test="//@SDIS">
                                <tr>
                                  <th align="left" nowrap="nowrap">SDIS = &#xa0;</th>
                                  <td align="left" nowrap="nowrap">
                                    <xsl:value-of select="cif:distanceFormat(number(@SDIS))"/>
                                  </td>
                                  <!-- <td align="right" colspan="1" lang="en"></td>-->
                                </tr>
                                <tr>
                                  <th align="left" nowrap="nowrap">DeltaZ = &#xa0;</th>
                                  <td align="left" nowrap="nowrap">
                                    <xsl:value-of select="cif:distanceFormat(number(@DeltaZ))"/>
                                  </td>
                                  <!-- <td align="right" colspan="1" lang="en"></td>-->
                                </tr>
                              </xsl:if>                              
                            </xsl:for-each>
                          </tr>
                        </tr>
                        <tr/>
                      </xsl:if>

                    </tbody>
                  </table>
                </xsl:for-each>

              </xsl:for-each>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </body>
    </html>
  </xsl:template>
  <xsl:template name="StyleSheetHelp">
    <div class="section1">
      <h4 lang="en">Poznámky</h4>
      <p class="normal1" lang="en">
        Pro tento výpis musíte mít nejméně jeden polní zápisník ve správci projektů (Zaměření- Survey), který obsahuje síť zaměření s vyrovnáním.
      </p>

      <p class="normal1">  Ve správci projektu zameření zkontroujte, zda je vpravo od Vyrovnání zelená ikonka zobrazující, že je vše kompletně zpracováno. Pravým tlačítkem na Vyrovnání, zvolte Výsledek vyrovnání a požadovaný výpis. </p>
      <p class="normal1">Jakmile je Průzkumník Civil výpisu otevřený, můžete zvolit další Výpis vyrovnání.</p>
      <p class="small" lang="en">
        <em>&#xa9; 2012 Bentley Systems, Inc</em>
      </p>
    </div>
  </xsl:template>
</xsl:stylesheet>
